﻿using System;
using Curse.AddOns;
using System.Threading;
using System.Configuration;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.IO;
using Curse.Extensions;
using System.Runtime.Serialization.Formatters.Binary;
using System.Linq;
using Curse.AddOnService.Extensions;
using Curse.Logging;

namespace Curse.AddOnService
{
    public class AvatarCache
    {
        private int _updateThreadInterval;
        private Thread _updateThread = null;
        private string _databaseConnectionString = null;
        private string _staticFileDestination = null;
        private bool _createFeedFiles = false;

        private static readonly AvatarCache _instance = new AvatarCache();
        private List<Avatar> _avatars = new List<Avatar>();
        private readonly string _baseAvatarUrl;

        public static AvatarCache Instance
        {
            get
            {
                return _instance;
            }
        }

        private AvatarCache()
        {
            _updateThreadInterval = int.Parse(ConfigurationManager.AppSettings["UpdateThreadInterval"]);
            _databaseConnectionString = ConfigurationManager.ConnectionStrings["RoamingDBRadon"].ConnectionString;
            _staticFileDestination = ConfigurationManager.AppSettings["FeedPath"];
            _baseAvatarUrl = ConfigurationManager.AppSettings["BaseAvatarUrl"];
            _createFeedFiles = (Environment.MachineName.ToLower() == ConfigurationManager.AppSettings["JobMachineName"].ToLower());


#if DEBUG
            _createFeedFiles = true;
#endif

            UpdateCache();
            
            _updateThread = new Thread(CacheThread) { IsBackground = true };
            _updateThread.Priority = ThreadPriority.Lowest;
            _updateThread.Start();
        }

        public DateTime FileDate
        {
            get;
            set;
        }

        public List<Avatar> Avatars { get { return _avatars; } }

        public void Initialize() { }

        private void CacheThread()
        {            
            while (true)
            {
                Thread.Sleep(_updateThreadInterval);
                try
                {
                    UpdateCache();
                }
                catch (ThreadAbortException)
                {                    
                    Logger.Info("Thread Abort Exception. Service shutting down.");
                    break;
                }
                catch (Exception ex)
                {

                    Logger.Error(ex, "Update Thread Exception!");
                }
            }
        }

        private void UpdateCache()
        {
            using (var conn = new SqlConnection(_databaseConnectionString))
            {
                try
                {
                    conn.Open();
                }
                catch (Exception ex)
                {
                    Logger.Error(ex, "Unable to establish connection to database", _databaseConnectionString);
                    return;
                }

                var avatars = new List<Avatar>();

                var command = new SqlCommand("SELECT ID, Status, FileName, FileLength, Width, Height FROM Avatar with(nolock) Where EntityTypeID in (10006, 10002)", conn);

                using (var reader = command.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        var avatar = new Avatar();
                        avatar.SetFromDataReader(reader);
                        avatar.Url = GetAvatarUrl(avatar);
                        avatars.Add(avatar);
                    }
                }

                lock (_avatars)
                {
                    _avatars = avatars;
                }
               
            }
        }


        private string GetAvatarUrl(Avatar avatar)
        {         
            var highID = avatar.Id / 1000;
            var lowID = avatar.Id % 1000;
            return _baseAvatarUrl + "/avatars/" + highID + "/" + lowID + "/" + avatar.FileName;
        }
        
    }
}
