﻿using System;
using System.Linq;
using System.Configuration;
using System.Threading;
using System.Data.SqlClient;
using System.Collections.Generic;
using Curse.AddOns;
using System.Data;
using Curse.Extensions;
using Curse.Logging;

namespace Curse.AddOnService
{
    public class CategorySectionCache
    {
        private List<CategorySection> _categorySections;
        private object _categorySectionLock = new object();

        private int _updateThreadInterval;
        private Thread _updateThread = null;
        private string _databaseConnectionString = null;

        private static readonly CategorySectionCache _instance = new CategorySectionCache();

        public static CategorySectionCache Instance
        {
            get
            {
                return _instance;
            }
        }

        private CategorySectionCache()
        {
            _updateThreadInterval = int.Parse(ConfigurationManager.AppSettings["UpdateThreadInterval"]);
            _databaseConnectionString = ConfigurationManager.ConnectionStrings["RoamingDBRadon"].ConnectionString;
            _categorySections = new List<CategorySection>();

            UpdateCache();

            _updateThread = new Thread(CacheThread) { IsBackground = true };
            _updateThread.Priority = ThreadPriority.Lowest;
            _updateThread.Start();
        }

        public void Initialize() { }

        private void CacheThread()
        {            
            while (true)
            {
                Thread.Sleep(_updateThreadInterval);
                try
                {
                    UpdateCache();
                }
                catch (ThreadAbortException)
                {                     
                    break;
                }
                catch (Exception ex)
                {
                    Logger.Error(ex, "Update Thread Exception");
                }
            }
        }

        private void UpdateCache()
        {
            using (var conn = new SqlConnection(_databaseConnectionString))
            {
                try
                {
                    conn.Open();
                }
                catch (Exception ex)
                {
                    Logger.Error(ex, "CategoryCache - Unable to establish connection to database", _databaseConnectionString);
                    return;
                }

                var sections = new List<CategorySection>();

                var command = new SqlCommand("spGetGameSectionsV2", conn);
                command.CommandType = CommandType.StoredProcedure;
                using (var reader = command.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        var section = new CategorySection();
                        section.ID = reader.GetInt32(reader.GetOrdinal("ProjectCategorySectionID"));
                        section.GameID = reader.GetInt32(reader.GetOrdinal("GameID"));
                        section.Name = reader.GetString(reader.GetOrdinal("SectionName"));
                        section.PackageType = (PackageTypes)reader.GetByte(reader.GetOrdinal("PackageType"));
                        section.Path = reader.GetNullableValue<string>("Path");
                        section.InitialInclusionPattern = reader.GetString(reader.GetOrdinal("InitialInclusionPattern"));
                        section.ExtraIncludePattern = reader.GetNullableValue<string>("ExtraInclusionPattern");

                        sections.Add(section);
                    }
                }

                lock (_categorySectionLock)
                {
                    _categorySections = sections;
                }
            }
        }

        public CategorySection GetByID(int sectionID)
        {
            return _categorySections.FirstOrDefault(p => p.ID == sectionID);
        }

        public List<CategorySection> GetAllSectionsByGameID(int gameId)
        {
            return _categorySections.Where(p => p.GameID == gameId).ToList();
        }
    }
}
