﻿using System;
using System.Configuration;
using Curse.CloudFlare;
using Curse.CloudFront;
using Curse.Logging;

namespace Curse.AddOnService
{
    public class CdnCacheInvalidator
    {
        private static bool _isEnabled;
        public static void Initialize()
        {
            _isEnabled = bool.Parse(ConfigurationManager.AppSettings["CdnInvalidationEnabled"]);
            CloudFlareApi.Initialize(ConfigurationManager.AppSettings["CloudFlareApiKey"], ConfigurationManager.AppSettings["CloudFlareApiEmailAddress"]);
            CloudFrontApi.Initialize(ConfigurationManager.AppSettings["CloudFrontAccessKey"], ConfigurationManager.AppSettings["CloudFrontSecretAccessKey"], ConfigurationManager.AppSettings["CloudFrontDistributionID"]);                

            Logger.Info("CDN Cache Invalidator has been initialized.", new { IsEnabled = _isEnabled });
        }

        public static void InvalidateUrl(string url)
        {
            if (!_isEnabled)
            {
                return;
            }

            try
            {
                Logger.Debug("Invalidating CloudFlare CDN resource at: " + url);
                var success = CloudFlareApi.InvalidateUrl(ConfigurationManager.AppSettings["CloudFlareDomain"], url);
                if (!success)
                {
                    throw new Exception("CloudFlare did not respond with a success message.");
                }
            }
            catch (Exception ex)
            {
                Logger.Warn(ex, "CloudFlare API invalidation failed!");
            }

            try
            {
                Logger.Debug("Invalidating CloudFront CDN resource at: " + url);
                var success = CloudFrontApi.InvalidateUrls(new[] { url });
                if (!success)
                {
                    throw new Exception("CloudFront did not respond with a success message.");
                }
            }
            catch (Exception ex)
            {
                Logger.Warn(ex, "CloudFront API invalidation failed!");
            }
            
            
        }
    }
}