﻿using Curse.AddOns;
using Curse.Extensions;
using System.Data.SqlClient;
using System.Configuration;

namespace Curse.AddOnService.Extensions
{
    public static class AddOnCategoryExtensions
    {
        private readonly static string sCategoryBaseUrl = null;

        static AddOnCategoryExtensions()
        {
            sCategoryBaseUrl = ConfigurationManager.AppSettings["CategoryBaseUrl"];
        }

        public static void SetFromDataReader(this AddOnCategory value, SqlDataReader reader)
        {
            value.Id = (int)reader["addon_category_id"];
            value.Name = (string)reader["addon_category_name"];
            value.URL = sCategoryBaseUrl.FormatWith((string)reader["addon_section"], (string)reader["addon_game_slug"], (string)reader["addon_category_slug"]);
        }
    }
}
