﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using Curse.AddOns;
using Curse.Extensions;
using System.Configuration;
using Curse.Logging;

namespace Curse.AddOnService.Extensions
{
    public static class AddOnFileExtension
    {
        private static readonly string sMediaFileUrl = null;
        
        static AddOnFileExtension()
        {
            sMediaFileUrl = ConfigurationManager.AppSettings["MediaFileUrl"];        
        }

        public static void SetFromDataReader(this AddOnFile file, SqlDataReader pReader, Dictionary<int, List<AddOnFileDependency>> dependencies, Dictionary<int, List<string>> gameVersions)
        {
            var gameID = pReader.GetInt32(pReader.GetOrdinal("file_game_id"));
            file.Id = pReader.GetInt32(pReader.GetOrdinal("file_id"));
            file.FileName = pReader.GetString(pReader.GetOrdinal("file_name"));
            file.FileNameOnDisk = pReader.GetString(pReader.GetOrdinal("file_filename"));
            file.FileDate = pReader.GetDateTime(pReader.GetOrdinal("file_date"));
            file.ReleaseType = (FileType)pReader.GetByte(pReader.GetOrdinal("file_type"));
            file.IsAlternate = pReader.GetBoolean(pReader.GetOrdinal("file_is_alternate"));
            file.FileStatus = (FileStatus)pReader.GetByte(pReader.GetOrdinal("file_status"));
            file.PackageFingerprint = pReader.GetNullableValue<long>("file_package_fingerprint");

            if (GameCache.Instance.AllowSemiNormal(gameID))
            {
                file.IsAvailable = ((file.FileStatus == FileStatus.Normal || file.FileStatus == FileStatus.SemiNormal) || (file.FileStatus == FileStatus.ClientOnly && file.IsAlternate));
            }
            else
            {
                file.IsAvailable = ((file.FileStatus == FileStatus.Normal) || (file.FileStatus == FileStatus.ClientOnly && file.IsAlternate));
            }

            if (dependencies.ContainsKey(file.Id))
            {
                file.Dependencies = dependencies[file.Id];
            }

            file.AlternateFileId = pReader.GetInt32(pReader.GetOrdinal("file_alternate_file_id"));
            file.DownloadURL = sMediaFileUrl.FormatWith(file.Id.ToModPath(), pReader["file_filename"]);
            file.Changelog = pReader.GetString(pReader.GetOrdinal("file_change_log"));

            if (gameVersions.ContainsKey(file.Id))
            {
                file.GameVersion = gameVersions[file.Id];
            }
        }

        public static string GetChangeLog(this AddOnFile file)
        {
            if (!string.IsNullOrEmpty(file.Changelog))
                return file.Changelog;

            if (FileCache.Instance.ChangeLogs.ContainsKey(file.Id))
                return FileCache.Instance.ChangeLogs[file.Id];

            using (var conn = new SqlConnection(ConfigurationManager.ConnectionStrings["RoamingDBRadon"].ConnectionString))
            {
                using (var cmd = new SqlCommand("select IsNull(ProjectFile.ChangeLog, '') from ProjectFile where ID = @id", conn))
                {
                    cmd.Parameters.Add("id", System.Data.SqlDbType.Int).Value = file.Id;

                    try
                    {
                        conn.Open();
                        file.Changelog = (string)cmd.ExecuteScalar();
                        FileCache.Instance.ChangeLogs.Add(file.Id, file.Changelog);
                    }
                    catch (Exception exc)
                    {
                        Logger.Error(exc, "Failed to pull changelog for file ID: " + file.Id);
                    }
                }
            }

            return file.Changelog;
        }
    }
}
