﻿using Curse.AddOns;
using Curse.Extensions;
using System.Data.SqlClient;
using System.Configuration;

namespace Curse.AddOnService.Extensions
{
    public static class AvatarExtension
    {
        private static readonly string _iconMediaUrl;

        static AvatarExtension() {
            _iconMediaUrl = ConfigurationManager.AppSettings["IconMediaUrl"];
        }//construct

        public static void SetFromDataReader(this Avatar avatar, SqlDataReader pReader)
        {
            avatar.Id = (int)pReader["Id"];
            avatar.FileName = (string)pReader["FileName"];
            avatar.Width = (int)pReader["Width"];
            avatar.Height = (int)pReader["Height"];
            avatar.FileLength = (long)pReader["FileLength"];
            avatar.Status = (AvatarStatus)pReader.GetByte(pReader.GetOrdinal("Status"));
            avatar.FilePath = string.Format(_iconMediaUrl, avatar.Id.ToModPath(), avatar.FileName);
        }// set from data reader
    }//class
}//namespace