﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.ClientService.Models;
using System.Data.SqlClient;
using System.Data;

namespace Curse.ClientService
{
    public static class CCampaignExtension
    {
        public static void SetFromDataReader(this CCampaign campaign, SqlDataReader reader, SqlConnection conn)
        {
            campaign.ID = (int)reader["ID"];
            campaign.Name = (string)reader["Name"];
            campaign.DateCreated = (DateTime)reader["DateCreated"];
            campaign.DateModified = (DateTime)reader["DateModified"];
            campaign.StartDate = (DateTime)reader["StartDate"];
            campaign.EndDate = (DateTime)reader["EndDate"];
            campaign.ThemeToken = (string)reader["ThemeToken"];
            campaign.LinkUrl = (string)reader["LinkUrl"];

            // Set the regions
            SqlCommand command = new SqlCommand("select RegionID from CampaignRegion where CampaignID = @CampaignID", conn);
            SqlParameter param = command.Parameters.Add("@CampaignID", SqlDbType.Int);
            param.Value = campaign.ID;

            List<int> regions = new List<int>();

            using (SqlDataReader regionReader = command.ExecuteReader())
            {
                while (regionReader.Read())
                {
                    regions.Add(regionReader.GetInt32(0));
                }
            }

            campaign.Regions = regions;


        }
    }
}
