﻿using System;
using System.Data.SqlClient;
using Curse.ClientService.Models;

namespace Curse.AddOnService.Extensions
{
    public static class CSyncedGameInstanceExtension
    {
        public static void SetFromDataReader(this SyncedGameInstance instance, SqlDataReader pReader)
        {            
            instance.InstanceID = (int)pReader["InstanceID"];
            instance.InstanceName = (string)pReader["InstanceName"];
            instance.LastBackupFingerprint = (long)pReader["LastBackupFingerprint"];
            instance.LastBackupScreenWidth = (int)pReader["LastBackupScreenWidth"];
            instance.LastBackupScreenHeight = (int)pReader["LastBackupScreenHeight"];

            if (pReader["LastBackupDate"] == System.DBNull.Value)
            {
                instance.LastBackupDate = DateTime.MinValue;
            }
            else
            {
                instance.LastBackupDate = (DateTime)pReader["LastBackupDate"];
            }

            instance.GameID = (int)pReader["GameID"];            
        }
    }
}
