﻿using System;
using System.Linq;
using Curse.AddOns;
using System.Data.SqlClient;
using Curse.Logging;

namespace Curse.AddOnService.Extensions
{
    public static class CategoryExtensions
    {
        public static void SetFromDataReader(this Category category, SqlDataReader pReader)
        {
            category.Id = (int)pReader["ID"];
            category.Name = (string)pReader["Name"];

            if (pReader["ParentCategoryId"] != System.DBNull.Value)
            {
                category.ParentId = (int)pReader["ParentCategoryId"];
            }

            category.Slug = (string)pReader["Slug"];

            try
            {
                if (pReader["AvatarID"] != DBNull.Value)
                {
                    var avatarID = (int)pReader["AvatarID"];
                    var avatar = AvatarCache.Instance.Avatars.FirstOrDefault(p => p.Id == avatarID);
                    if (avatar != null)
                    {

                        category.AvatarUrl = avatar.Url;
                    }
                }
            }
            catch (Exception exc)
            {
                Logger.Error(exc, "Failed to get avatar from avatar cache.");
            }
        }
    }
}
