﻿using System;
using System.ServiceModel;
using Curse.ClientService.Models;

namespace Curse.AddOnService
{
    [ServiceBehavior(Name = "CClientStartupService",
        Namespace = "http://clientservice.curse.com/",
        AddressFilterMode = AddressFilterMode.Any,
        ConcurrencyMode = ConcurrencyMode.Multiple,
        InstanceContextMode = InstanceContextMode.PerCall)]
    public class FeedFileService : IFeedFileService
    {
        public DateTime GetCacheFileDate(CacheFileType type)
        {
            switch (type)
            {
                case CacheFileType.GameCache:
                    return GameCache.Instance.FileDate;

                case CacheFileType.CategoryCache:
                    return CategoryCache.Instance.FileDate;

                default:
                    return DateTime.UtcNow.AddYears(-1);
            }
        }        
    }
}
