﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Runtime.Serialization;
using Curse.Database.Helpers;

namespace Curse.AddOnService.GameManagement
{
    public class Game
    {
        [DataMember]
        public int ID { get; set; }

        [DataMember]
        public DateTime DateModified { get; set; }

        [DataMember]
        public string Name { get; set; }

        [DataMember]
        public string Slug { get; set; }

        [DataMember]
        public bool SupportsAddons { get; set; }

        [DataMember]
        public bool SupportsVoice { get; set; }

        [DataMember]
        public int Order { get; set; }

        [DataMember]
        public bool SupportsNotifications { get; set; }

        [DataMember]
        public bool BundleAssets { get; set; }

        public Game()
        {
            
        }

        private Game(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            DateModified = reader.GetDateTime(1).FixDBTimeToUTC();
            Name = reader.GetString(2);
            Slug = reader.GetString(3);
            SupportsAddons = reader.GetBoolean(4);
            SupportsVoice = reader.GetBoolean(5);
            Order = reader.GetInt32(6);
            SupportsNotifications = reader.GetBoolean(7);
            BundleAssets = reader.GetBoolean(8);
        }

        public void SaveToDatabase()
        {
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.Parameters.AddWithValue("@ID", ID);
                    command.Parameters.AddWithValue("@Name", Name);
                    command.Parameters.AddWithValue("@Slug", Slug);
                    command.Parameters.AddWithValue("@SupportsAddons", SupportsAddons);
                    command.Parameters.AddWithValue("@SupportsVoice", SupportsVoice);
                    command.Parameters.AddWithValue("@Order", Order);
                    command.Parameters.AddWithValue("@SupportsNotifications", SupportsNotifications);
                    command.Parameters.AddWithValue("@BundleAssets", BundleAssets);

                    command.CommandText = String.Format(@"UPDATE [Game] SET DateModified=GETUTCDATE(),[Order]=@Order,{1}=@{1},{2}=@{2},{3}=@{3},{4}=@{4},{5}=@{5},{6}=@{6} WHERE {0}=@{0} IF @@ROWCOUNT = 0 INSERT INTO [Game] (DateModified,[Order],{0},{1},{2},{3},{4},{5},{6}) VALUES (GETUTCDATE(),@Order,@{0},@{1},@{2},@{3},@{4},@{5},@{6})", 
                        "ID", "Name", "Slug", "SupportsAddons", "SupportsVoice", "SupportsNotifications", "BundleAssets");
                    command.ExecuteNonQuery();
                }
            }
        }

        public void Delete()
        {
            if (ID == 0)
            {
                throw new InvalidOperationException("Cannot delete a game from the database without an ID");
            }

            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "DELETE FROM [Game] WHERE ID=@ID";
                    command.Parameters.AddWithValue("@ID", ID);
                    command.ExecuteNonQuery();
                }
            }
        }

        public static Game[] GetAll()
        {
            var games = new List<Game>();
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [Game]";
                    using (var reader = command.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            games.Add(new Game(reader));
                        }
                    }
                }
            }
            return games.ToArray();
        }

        public static Game Get(int id)
        {
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [Game] where ID=@ID";
                    command.Parameters.AddWithValue("@ID", id);

                    using (var reader = command.ExecuteReader())
                    {
                        return reader.Read() ? new Game(reader) : null;
                    }
                }
            }
        }
    }
}