﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Runtime.Serialization;
using Curse.Database.Helpers;

namespace Curse.AddOnService.GameManagement
{
    public enum HintType
    {
        Unknown = 0,
        Registry = 1,
        FilePath = 2
    }

    public class GameDetectionHint
    {
        [DataMember]
        public int ID { get; set; }

        [DataMember]
        public int GameID { get; set; }

        [DataMember]
        public HintType HintType { get; set; }

        [DataMember]
        public string HintPath { get; set; }

        [DataMember]
        public string HintKey { get; set; }

        public GameDetectionHint()
        {
            
        }

        private GameDetectionHint(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            GameID = reader.GetInt32(1);
            HintType = (HintType) reader.GetInt32(2);
            HintPath = reader.GetString(3);
            HintKey = reader.GetString(4);
        }

        public void SaveToDatabase()
        {
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.Parameters.AddWithValue("@GameID", GameID);
                    command.Parameters.AddWithValue("@HintType", (int)HintType);
                    command.Parameters.AddWithValue("@HintPath", HintPath);
                    command.Parameters.AddWithValue("@HintKey", HintKey);

                    if (ID == 0)
                    {
                        command.CommandText = string.Format("INSERT INTO [GameDetectionHint] ({0},{1},{2},{3}) OUTPUT INSERTED.ID VALUES (@{0},@{1},@{2},@{3})",
                            "GameID", "HintType", "HintPath", "HintKey");
                        ID = (int)command.ExecuteScalar();
                    }
                    else
                    {
                        command.CommandText = string.Format("UPDATE [GameDetectionHint] SET {0}=@{0},{1}=@{1},{2}=@{2},{3}=@{3} WHERE ID=@ID",
                            "GameID", "HintType", "HintPath", "HintKey");
                        command.Parameters.AddWithValue("@ID", ID);
                        command.ExecuteNonQuery();
                    }
                }
            }
        }

        public void Delete()
        {
            if (ID == 0)
            {
                throw new InvalidOperationException("Cannot delete a game from the database without an ID");
            }

            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "DELETE FROM [GameDetectionHint] WHERE ID=@ID";
                    command.Parameters.AddWithValue("@ID", ID);
                    command.ExecuteNonQuery();
                }
            }

        }

        public static GameDetectionHint[] GetAllForGame(int gameID)
        {
            var hints = new List<GameDetectionHint>();
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [GameDetectionHint] WHERE GameID=@GameID";
                    command.Parameters.AddWithValue("@GameID", gameID);

                    using (var reader = command.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            hints.Add(new GameDetectionHint(reader));
                        }
                    }
                }
            }

            return hints.ToArray();
        }

        public static GameDetectionHint Get(int id)
        {
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [GameDetectionHint] WHERE ID=@ID";
                    command.Parameters.AddWithValue("@ID", id);

                    using (var reader = command.ExecuteReader())
                    {
                        return reader.Read() ? new GameDetectionHint(reader) : null;
                    }
                }
            }
        }
    }
}