﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Runtime.Serialization;
using Curse.Database.Helpers;

namespace Curse.AddOnService.GameManagement
{
    public enum GamePlatformType
    {
        Unknown = 0,
        Generic = 1,
        Windows32,
        Windows64,
        Windows,
        OSX
    }
    public enum GameFileType
    {
        Unknown = 0,
        Generic = 1,
        Game,
        Launcher,
        ProfilerLockCheck,
    }

    public class GameFile
    {
        [DataMember]
        public int ID { get; set; }

        [DataMember]
        public int GameID { get; set; }

        [DataMember]
        public string FileName { get; set; }

        [DataMember]
        public bool IsRequired { get; set; }

        [DataMember]
        public GameFileType FileType { get; set; }

        [DataMember]
        public GamePlatformType PlatformType { get; set; }

        public GameFile()
        {
            
        }

        private GameFile(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            GameID = reader.GetInt32(1);
            FileName = reader.GetString(2);
            IsRequired = reader.GetBoolean(3);
            FileType = (GameFileType)reader.GetInt32(4);
            PlatformType = (GamePlatformType) reader.GetInt32(5);
        }

        public void SaveToDatabase()
        {
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.Parameters.AddWithValue("@GameID", GameID);
                    command.Parameters.AddWithValue("@FileName", FileName);
                    command.Parameters.AddWithValue("@IsRequired", IsRequired);
                    command.Parameters.AddWithValue("@FileType", (int) FileType);
                    command.Parameters.AddWithValue("@PlatformType", (int) PlatformType);

                    if (ID == 0)
                    {
                        command.CommandText = string.Format("INSERT INTO [GameFile] ({0},{1},{2},{3},{4}) OUTPUT INSERTED.ID VALUES (@{0},@{1},@{2},@{3},@{4})",
                            "GameID", "FileName", "IsRequired", "FileType", "PlatformType");
                        ID = (int)command.ExecuteScalar();
                    }
                    else
                    {
                        command.CommandText = string.Format("UPDATE [GameFile] SET {0}=@{0},{1}=@{1},{2}=@{2},{3}=@{3},{4}=@{4} WHERE ID=@ID",
                            "GameID", "FileName", "IsRequired", "FileType", "PlatformType");
                        command.Parameters.AddWithValue("@ID", ID);
                        command.ExecuteNonQuery();
                    }
                }
            }
        }

        public void Delete()
        {
            if (ID == 0)
            {
                throw new InvalidOperationException("Cannot delete a GameFile without a valid ID");
            }

            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "DELETE FROM [GameFile] WHERE ID=@ID";
                    command.Parameters.AddWithValue("@ID", ID);
                    command.ExecuteNonQuery();
                }
            }
        }

        public static GameFile[] GetAllForGame(int gameID)
        {
            var files = new List<GameFile>();
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [GameFile] WHERE GameID=@GameID";
                    command.Parameters.AddWithValue("@GameID", gameID);

                    using (var reader = command.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            files.Add(new GameFile(reader));
                        }
                    }
                }
            }
            return files.ToArray();
        }

        public static GameFile Get(int id)
        {
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.RadiumService))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [GameFile] WHERE ID=@ID";
                    command.Parameters.AddWithValue("@ID", id);

                    using (var reader = command.ExecuteReader())
                    {
                        return reader.Read() ? new GameFile(reader) : null;
                    }
                }
            }
        }
    }
}