﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using System.Net.Security;

using Curse.AddOns;
using Curse.ClientService.Models;
using System.IO;
using Curse.AddOnService.Requests;
using Curse.CloudServices.Authentication;

namespace Curse.AddOnService
{
    [ServiceContract(Namespace = "http://addonservice.curse.com/", ProtectionLevel=ProtectionLevel.None)]
    public interface IAddOnService
    {       
        #region Addons
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetAddOn?id={id}", Method = "POST")]
        AddOn GetAddOn(int id);
        
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetRepositoryMatchFromSlug?gameSlug={gameSlug}&addonSlug={addonSlug}", Method = "POST")]
        RepositoryMatch GetRepositoryMatchFromSlug(string gameSlug, string addonSlug);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetChangeLog?addonID={addonID}&fileID={fileID}", Method = "POST")]
        string GetChangeLog(int addonID, int fileID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/v2GetChangeLog?addonID={addonID}&fileID={fileID}", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Json)]
        string v2GetChangeLog(int addonID, int fileID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetAddOnDescription?id={id}", Method = "POST")]
        string GetAddOnDescription(int id);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/v2GetAddOnDescription?id={id}", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Json)]
        string v2GetAddOnDescription(int id);
        
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetAddOnFile?addonID={addonID}&fileID={fileID}", Method = "POST")]
        AddOnFile GetAddOnFile(int addonID, int fileID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetAddOns", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        List<AddOn> GetAddOns(int[] ids);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/v2GetAddOns", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Json)]
        List<AddOn> v2GetAddOns(int[] ids);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetFingerprintMatches", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        FingerprintMatchResult GetFingerprintMatches(long[] fingerprints);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/v2GetFingerprintMatches", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Json)]
        FingerprintMatchResult v2GetFingerprintMatches(long[] fingerprints);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetFuzzyMatches", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        List<FuzzyMatch> GetFuzzyMatches(int gameID, FolderFingerprint[] folderFingerprints);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetDownloadToken?fileid={fileid}", Method = "POST")]
        DownloadToken GetDownloadToken(int fileID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetSecureDownloadToken", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        DownloadToken GetSecureDownloadToken(int fileID, int userID, bool hasPremium, int subscriptionToken);

        #endregion              

        #region Addon Sync (Premium Only)

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        ServiceResponse<List<SyncedGameInstance>> GetSyncProfile();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        [WebInvoke(UriTemplate = "/CreateSyncGroup", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse<SyncedGameInstance> CreateSyncGroup(string instanceName, int gameID, string computerName, string instanceGUID, string instanceLabel);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        [WebInvoke(UriTemplate = "/JoinSyncGroup", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse JoinSyncGroup(int instanceID, string computerName, string instanceGUID, string instanceLabel);       

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        [WebInvoke(UriTemplate = "/LeaveSyncGroup", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse LeaveSyncGroup(int instanceID, int computerID, string instanceGUID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        [WebInvoke(UriTemplate = "/SaveSyncSnapshot", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse SaveSyncSnapshot(int instanceID, SyncedAddon[] syncedAddons);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.PremiumPromotion)]
        [WebInvoke(UriTemplate = "/SaveSyncTransactions", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse SaveSyncTransactions(int instanceID, SyncTransaction[] transactions);

        #endregion

        #region Saved Game Sync
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetSavedGames", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse<List<SavedGame>> GetSavedGames();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/DeleteSavedGame", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse DeleteSavedGame(int savedGameId);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/DeleteSavedGameRevision", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse DeleteSavedGameRevision(int savedGameId, int savedGameRevisionId);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SetSavedGameStatus", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse SetSavedGameStatus(int savedGameId, ESavedGameStatus status);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SetSavedGameName", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse SetSavedGameName(int savedGameId, string name);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SetSavedGameDescription", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse SetSavedGameDescription(int savedGameId, string description);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SetSavedGameDefaultRevision", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse SetSavedGameDefaultRevision(int savedGameId, int revisionId);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SetSavedGameFavoriteRevision", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse SetSavedGameFavoriteRevision(int savedGameId, int revisionId);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetSavedGameConstraints", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse<SavedGameConstraints> GetSavedGameConstraints();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetSavedGameRestrictionLevel", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse<ESavedGameRestrictionLevel> GetSavedGameRestrictionLevel();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/UploadAvailableForUser", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse UploadAvailableForUser();
        #endregion

        #region Admin Only

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Administrator)]
        Stream GetAddOnDump(int id);        

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Administrator)]        
        string ResetAllAddonCache();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Administrator)]        
        string ResetSingleAddonCache(int id);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Administrator)]
        ServiceResponse SetSavedGameRestrictionLevel(ESavedGameRestrictionLevel restrictionLevel);
        #endregion

        #region Tests

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        [WebInvoke(UriTemplate = "/HealthCheck", Method = "GET")]
        string HealthCheck();

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        [WebInvoke(UriTemplate = "/CacheHealthCheck", Method = "GET")]
        string CacheHealthCheck();

#if DEBUG
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        [WebInvoke(UriTemplate = "/TestDatabaseReadSpeed", Method = "GET")]
        string TestDatababaseReadSpeed();
#endif

        #endregion

        #region AddOn Files

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetAllFilesForAddon?addOnID={addOnID}", Method = "GET", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Json)]
        AddOnFile[] GetAllFilesForAddOn(int addOnID);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetAddOnFiles", Method = "POST", BodyStyle = WebMessageBodyStyle.Bare, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        Dictionary<int, List<AddOnFile>> GetAddOnFiles(List<AddOnFileKey> addOnFileKeys);

        #endregion

    }
}
