﻿using System.ServiceModel;
using Curse.ClientService.Models;
using System.Net.Security;
using Curse.CloudServices.Authentication;

namespace Curse.AddOnService
{
    // NOTE: If you change the interface name "ICClientRegistrationService" here, you must also update the reference to "ICClientRegistrationService" in Web.config.
    [ServiceContract(Namespace = "http://addonservice.curse.com/", ProtectionLevel = ProtectionLevel.None)]
    public interface IAddOnSyncFileService
    {
        [OperationContract(Action = "SaveUserBackup", IsOneWay = true)]
        [RequiresAuthentication(AccessLevel.PremiumSubscription)]
        void SaveUserBackup(UserBackupMessage request);

        [OperationContract(Action = "SyncSavedGame", IsOneWay = true)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        void SyncSavedGame(SavedGameSyncMessage request);

        [OperationContract(Action = "AddRevision", IsOneWay = true)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        void AddRevision(SavedGameSyncMessage request);
    }
}
