﻿using System.ServiceModel;
using Curse.AddOnService.GameManagement;
using Curse.AddOnService.Responses;
using Curse.CloudServices.Authentication;

namespace Curse.AddOnService
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the interface name "IGameManagementService" in both code and config file together.
    [ServiceContract(Namespace = "http://addonservice.curse.com/")]
    public interface IGameManagementService
    {
        [OperationContract]
        GetAllGamesResponse GetAllGames(string apiKey);

        [OperationContract]
        GetGameDetailsResponse GetGameDetails(int gameID, string apiKey);

        [OperationContract]
        BasicServiceResponse CreateGame(Game newGame, string apiKey);

        [OperationContract]
        BasicServiceResponse UpdateGame(Game updatedGame, string apiKey);

        [OperationContract]
        CreateResponse CreateGameDetectionHint(GameDetectionHint newGameDetectionHint, string apiKey);

        [OperationContract]
        BasicServiceResponse UpdateGameDetectionHint(GameDetectionHint updatedGameDetectionHint, string apiKey);

        [OperationContract]
        BasicServiceResponse DeleteGameDetectionHint(int hintID, string apiKey);

        [OperationContract]
        CreateResponse CreateGameFile(GameFile newGameFile, string apiKey);

        [OperationContract]
        BasicServiceResponse UpdateGameFile(GameFile updatedGameFile, string apiKey);

        [OperationContract]
        BasicServiceResponse DeleteGameFile(int fileID, string apiKey);
    }
}
