﻿using System;
using System.ServiceModel;
using Curse.Logging;
using Curse.Minecraft.Models;

namespace Curse.AddOnService
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the class name "MinecraftService" in code, svc and config file together.
    // NOTE: In order to launch WCF Test Client for testing this service, please select MinecraftService.svc or MinecraftService.svc.cs at the Solution Explorer and start debugging.
    [ServiceBehavior]
    public class MinecraftAddonService : IMinecraftAddOnService
    {
        
        public MinecraftGameVersion GetMinecraftVersion(string key)
        {
            try
            {
                return MinecraftCache.Instance.GetMinecraftVersionByKey(key);
            }
            catch (Exception ex)
            {
                Logger.Error(ex);
                return null;
            }
        }


        public MinecraftModLoaderVersion GetModLoader(string key)
        {
            try
            {
                return MinecraftCache.Instance.GetMinecraftModLoaderByKey(key);
            }
            catch (Exception ex)
            {
                Logger.Error(ex);
                return null;
            }
        }      
    }
}
