﻿using Curse.Logging;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;

namespace Curse.AddOnService.Utilities
{
    public static class FileHelper
    {
        public static void ReplaceFile(string currentFile, string newFile)
        {
            var path = Path.GetDirectoryName(currentFile);
            var backupFile = Path.Combine(path, newFile + ".bak");

            try
            {
                if (File.Exists(currentFile))
                {
                    File.Replace(newFile, currentFile, backupFile, true);
                }
                else
                {
                    File.Copy(newFile, currentFile, true);
                }
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "SaveJsonToDisk Exception!");
                return;
            }
            finally
            {
                try
                {
                    File.Delete(newFile);
                    if (File.Exists(backupFile))
                    {
                        File.Delete(backupFile);
                    }
                }
                catch (Exception ex)
                {
                    Logger.Error(ex, "Failed to cleanup temp files.");
                }
            }
        }
    }
}