﻿using System;
using Curse.Logging;


namespace Curse.Caching
{
    internal static class CacheLog
    {
        private static bool _isInitialized = false;

        public static void Initialize()
        {
            _isInitialized = true;
        }

        public static void Info(string message, params object[] args)
        {
            if (!_isInitialized)
            {
                return;
            }
            Logger.Info(string.Format(message, args));
        }

        public static void Warn(string message, params object[] args)
        {
            if (!_isInitialized)
            {
                return;
            }
            Logger.Warn(string.Format(message, args));            
        }

        public static void Error(string message)
        {
            if (!_isInitialized)
            {
                return;
            }
            Logger.Error(message);            
        }

        public static void Exception(Exception ex, string message = null, params object[] args)
        {
            if (!_isInitialized)
            {
                return;
            }

            if (message != null)
            {
                message = string.Format(message, args);
            }

            Logger.Error(ex, message);            
        }

    }
}
