﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.Web;

namespace Curse.Caching
{
    [ServiceBehavior(ConcurrencyMode = ConcurrencyMode.Multiple, 
        InstanceContextMode = InstanceContextMode.Single, 
        AddressFilterMode = AddressFilterMode.Any, UseSynchronizationContext = false)]
    public class CacheService : ICacheService
    {
        public void ExpireCacheKeys(string[] cacheKeys)
        {
            CacheCluster.Instance.ReceiveInvalidationKey(cacheKeys);
            Console.WriteLine("[" + DateTime.Now.Minute + ":" + DateTime.Now.Second.ToString("00") + "] Received " + cacheKeys.Count().ToString("###,##0") + " invalidation keys!");
        }

        public void RegisterSelf(int id, string ipAddress, int portNumber)
        {
            ClusterManager.Instance.AddMember(id);
            CacheCluster.Instance.RegisterMember(id, ipAddress, portNumber);
        }
    }
}
