﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;

namespace Curse.Database.Helpers
{
    public enum DatabaseType
    {
        Elerium,
        RadiumService,
    }

    public static class DatabaseConnectionHelper
    {
        private static Dictionary<DatabaseType, string> _connectionStrings;

        public static void Initialize(IDictionary<DatabaseType, string> connectionStrings)
        {
            _connectionStrings = new Dictionary<DatabaseType, string>(connectionStrings);
        }

        public static SqlConnection GetConnection(DatabaseType dbType)
        {
            string connectionString;
            if (_connectionStrings == null || !_connectionStrings.TryGetValue(dbType, out connectionString))
            {
                throw new InvalidOperationException(string.Format("Database Helper was not initialized with a connection string for {0}.", dbType));
            }

            var connection = new SqlConnection(connectionString);
            connection.Open();
            return connection;
        }
    }
}