﻿using System;
using System.Data.SqlClient;

namespace Curse.Database.Helpers
{
    public static class DatabaseExtensions
    {
        public static object ValueOrDBNull(this object value)
        {
            return value ?? DBNull.Value;
        }

        public static DateTime FixDBTimeToUTC(this DateTime dbTime)
        {
            return DateTime.SpecifyKind(dbTime, DateTimeKind.Utc).ToUniversalTime();
        }

        public static T Get<T>(this SqlDataReader reader, string columnName)
        {
            var value = reader[columnName];
            return value == DBNull.Value ? default(T) : (T) value;
        }
    }
}
