﻿using System;
using System.Text.RegularExpressions;

namespace Curse.WAR
{
    public sealed class ClientVersion
         : IPackable
    {                
        public Int32 Value = 0;

        
        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }


        //Parse out a numeric representation of Version 0.5.5 Build 292
        private static Regex sVersionRegex = new Regex("Version (?<Major>[0-9]+)\\.(?<Minor>[0-9]+)\\.(?<Revision>[0-9]+) Build (?<Build>[0-9]+)", RegexOptions.Compiled);
        public Boolean Read(IReadable pBuf)
        {
            String version = null;
            if (!pBuf.Read(ref version))
            {
                return false;
            }

            Match versionMatch = sVersionRegex.Match(version);
            if (!versionMatch.Success)
            {
                return false;
            }                
            int Major = int.Parse(versionMatch.Groups["Major"].Value);
            int Minor = int.Parse(versionMatch.Groups["Minor"].Value);
            int Revision = int.Parse(versionMatch.Groups["Revision"].Value);
            int Build = int.Parse(versionMatch.Groups["Build"].Value);
            Value = (Major * 100000) + (Minor * 10000) + (Revision * 1000) + Build;
            return true;
        }
    }
}
