﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.WAR
{
    public sealed class Guild
         : IPackable
    {

        public EntityName Name = new EntityName();
        public String Details = null;
        public String Summary = null;
        public String WebSite = null;
        public String Email = null;
        public String CreationDate = null;

        public Byte Rank = 0;
        public Int32 Renown = 0;
        public Int32 XpCurrent = 0;
        public Int32 XpNeeded = 0;
        public Byte PlayStyle = 0;
        public UInt16 BannersCaptured = 0;
        public UInt16 BannersLost = 0;
        public PackableList<GuildRosterEntry> Roster = new PackableList<GuildRosterEntry>();
        public PackableList<GuildNewsEntry> News = new PackableList<GuildNewsEntry>();        
        
        public Boolean Read(IReadable pBuf)
        {
            bool ok = Name.Read(pBuf) &&
                pBuf.Read(ref Details) &&
                pBuf.Read(ref Summary) &&
                pBuf.Read(ref WebSite) &&
                pBuf.Read(ref Email) &&
                pBuf.Read(ref CreationDate) &&
                pBuf.Read(ref Rank) &&
                pBuf.Read(ref Renown) &&
                pBuf.Read(ref XpCurrent) &&
                pBuf.Read(ref XpNeeded) &&
                pBuf.Read(ref PlayStyle) &&
                pBuf.Read(ref BannersCaptured) &&
                pBuf.Read(ref BannersLost) &&
                Roster.Read(pBuf) &&
                News.Read(pBuf);
            return ok;

        }

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }
    }
}