﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.WAR
{
    public sealed class Player
         : IPackable
    {

        public EntityName Name = new EntityName();
        public Int32 XpRest = 0;
        public Int32 XpNeeded = 0;
        public Int32 XpEarned = 0;
        public Int32 Armor = 0;
        public Byte Level = 0;
        public Byte Race = 0;
        public Byte Career = 0;
        public UInt16 HitPoints = 0;
        public UInt16 ActionPoints = 0;
        public UInt16 DPS = 0;
        public UInt16 LifetimeKills = 0;
        public UInt16 LifetimeDeaths = 0;
        public UInt16 LifetimeDeathBlows = 0;
        public Byte RenownRank = 0;
        public EntityName RenownTitle = new EntityName();        
        public Int32 RenownEarned = 0;
        public Int32 RenownNeeded = 0;
        public PackableList<PlayerStat> Stats = new PackableList<PlayerStat>();
        public PackableList<PlayerEquipment> Equipment = new PackableList<PlayerEquipment>();
        public PackableList<PlayerInfluence> Influence = new PackableList<PlayerInfluence>();
        public PackableInt32List Titles  = new PackableInt32List();
        public PackableInt32List Achievements = new PackableInt32List();
        public PackableList<PlayerItem> Inventory = new PackableList<PlayerItem>();
        public PackableList<PlayerItem> QuestItems = new PackableList<PlayerItem>();
        public PackableList<PlayerTradeskill> Tradeskills = new PackableList<PlayerTradeskill>();
        
        
        public Boolean Read(IReadable pBuf)
        {
            bool ok = Name.Read(pBuf) &&
                pBuf.Read(ref XpRest) &&
                pBuf.Read(ref XpNeeded) &&
                pBuf.Read(ref XpEarned) &&
                pBuf.Read(ref Armor) &&
                pBuf.Read(ref Level) &&
                pBuf.Read(ref Race) &&
                pBuf.Read(ref Career) &&
                pBuf.Read(ref HitPoints) &&
                pBuf.Read(ref ActionPoints) &&
                pBuf.Read(ref DPS) &&
                pBuf.Read(ref LifetimeKills) &&
                pBuf.Read(ref LifetimeDeaths) &&
                pBuf.Read(ref LifetimeDeathBlows) &&
                pBuf.Read(ref RenownRank) &&
                RenownTitle.Read(pBuf) &&
                pBuf.Read(ref RenownEarned) &&
                pBuf.Read(ref RenownNeeded) &&
                Stats.Read(pBuf) &&
                Equipment.Read(pBuf) &&
                Influence.Read(pBuf) &&
                Titles.Read(pBuf) &&
                Achievements.Read(pBuf) &&
                Inventory.Read(pBuf) &&
                QuestItems.Read(pBuf) &&
                Tradeskills.Read(pBuf);
            return ok;

        }

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }
    }
}
