﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.WAR
{
    public sealed class PublicQuestStage
         : IPackable
    {

        public UInt16 MaxTimer = 0;
        public Byte InfluenceType = 0;
        public Byte AvailableRealm = 0;
        public String Name = null;
        public String TimerName = null;
        public String Description = null;
        public PackableList<QuestCondition> Conditions = new PackableList<QuestCondition>();


        public Boolean Read(IReadable pBuf)
        {
            bool ok = pBuf.Read(ref MaxTimer) &&
                pBuf.Read(ref InfluenceType) &&
                pBuf.Read(ref AvailableRealm) &&
                pBuf.Read(ref Name) &&
                pBuf.Read(ref TimerName) &&
                pBuf.Read(ref Description) &&
                Conditions.Read(pBuf);

            return ok;

        }

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }
    }
}
