﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.WAR
{
    public sealed class QuestCondition
         : IPackable
    {

        public String Name = null;
        public Byte FailureCondition = 0;
        public UInt16 Count = 0;
        public Byte ActionType = 0;
        public EntityName ActionName = new EntityName();
        public Int32 ActionId = 0;       
        public PackableList<EntityLocation> ActionPositions = new PackableList<EntityLocation>();

        public Boolean Read(IReadable pBuf)
        {
            bool ok = pBuf.Read(ref Name) &&
                pBuf.Read(ref FailureCondition) &&
                pBuf.Read(ref Count) &&
                pBuf.Read(ref ActionType) &&
                ActionName.Read(pBuf) &&
                pBuf.Read(ref ActionId) &&                
                ActionPositions.Read(pBuf);
            return ok;

        }

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }
    }
}
