﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WAR
{    
    public class Update : IPackable
    {

        // Private Variables
        private Int64 mMinProfilerversion = 0;
        private Int32[] mSupportedClientVersions = null;
        private String[] mSupportedLocales = null;

        // Status
        public StatusCode UpdateStatus = StatusCode.Ok;
        public Int32 UserId = 0;
        public String UserHost = null;
        public bool IsTrustedUser = false;
        public bool IsSupportedLanguage = false;

        // Header Block
        public ClientVersion ClientVersion = new ClientVersion();
        public String ServerName = null;
        public ELocale Language = 0;
        public Int64 ProfilerVersion = 0;

        // Error Block
        public PackableStringList Errors = new PackableStringList();

        
        // Data Block
        public PackableList<Area> Areas = new PackableList<Area>();
        public PackableList<NPC> NPCs = new PackableList<NPC>();
        public PackableList<GameObject> GameObjects = new PackableList<GameObject>();
        public PackableList<Item> Items = new PackableList<Item>();
        public PackableList<ItemSet> ItemSets = new PackableList<ItemSet>();
        public PackableList<Advance> Advances = new PackableList<Advance>();
        public PackableList<Ability> Abilities = new PackableList<Ability>();        
        public PackableList<Influence> Influence = new PackableList<Influence>();
        public PackableList<Quest> Quests = new PackableList<Quest>();
        public PackableList<PublicQuest> PublicQuests = new PackableList<PublicQuest>();
        public PackableList<IDEntry> IDMappings = new PackableList<IDEntry>();
        public PackableList<Player> Players = new PackableList<Player>();
        public PackableList<Guild> Guilds = new PackableList<Guild>();
        public PackableInt32List LootHistory = new PackableInt32List();
        public PackableList<BattlefieldStatus> BattlefieldStatus = new PackableList<BattlefieldStatus>();

        public Boolean Write(IWriteable pBuf)
        {
            return true;
        }

        public Update(Int64 pMinProfilerVersion, Int32[] pSupportedClientVersions, String[] pSupportedLocales, Int32 pUserId, Boolean pIsTrustedUser)
        {
            mMinProfilerversion = pMinProfilerVersion;
            mSupportedClientVersions = pSupportedClientVersions;
            mSupportedLocales = pSupportedLocales;
            UserId = pUserId;
            IsTrustedUser = pIsTrustedUser;
        }

        public Boolean Read(IReadable pBuf)
        {
            Int16 padding = 0;
            pBuf.Read(ref padding);
            byte languageId = 0;
            bool headerStatus = pBuf.Read(ref ProfilerVersion) &&
                ClientVersion.Read(pBuf) &&
                pBuf.Read(ref ServerName) &&
                pBuf.Read(ref languageId);
                              
            if (!headerStatus) 
            {
                UpdateStatus = StatusCode.InvalidStream;
                return false;
            }

            if(ProfilerVersion < mMinProfilerversion)
            {
                UpdateStatus = StatusCode.InvalidProfilerVersion;
                return false;
            }

            if (Array.IndexOf(mSupportedClientVersions, ClientVersion.Value) == -1)
            {
                UpdateStatus = StatusCode.InvalidGameClientVersion;
                return false;
            }

            Language = (ELocale)languageId;
            if (Array.IndexOf(mSupportedLocales, Language.ToString()) >= 0)
            {
                IsSupportedLanguage = true;
            }
            
            bool errorStatus = Errors.Read(pBuf);
            if (!errorStatus)
            {
                return false;
            }

            if (Errors.Count > 0)
            {
                Logger.Log(ELogLevel.Error, UserHost, "LUA Errors: {0}", String.Join(Environment.NewLine, Errors.ToArray()));
                return false;
            }

            bool dataStatus = NPCs.Read(pBuf);
            dataStatus = dataStatus && GameObjects.Read(pBuf);
            dataStatus = dataStatus && Items.Read(pBuf);
            dataStatus = dataStatus && ItemSets.Read(pBuf);
            dataStatus = dataStatus && Advances.Read(pBuf);
            dataStatus = dataStatus && Abilities.Read(pBuf);
            dataStatus = dataStatus && Influence.Read(pBuf);
            dataStatus = dataStatus && Quests.Read(pBuf);
            dataStatus = dataStatus && PublicQuests.Read(pBuf);
            dataStatus = dataStatus && IDMappings.Read(pBuf);
            dataStatus = dataStatus && Guilds.Read(pBuf);            

            if (Guilds.Count > 0 && Guilds[0].Name.Value.Length == 0)
            {
                Guilds.Clear();
            }
            dataStatus = dataStatus && Players.Read(pBuf);
            dataStatus = dataStatus && LootHistory.Read(pBuf);

            if (ProfilerVersion >= 2008081800)
            {
                dataStatus = dataStatus && BattlefieldStatus.Read(pBuf);
            }


            if (UserId > 1 && (ServerName == "Warpstone" || ServerName == "Deathsword"))
            {
                UpdateStatus = StatusCode.InvalidGameClientVersion;
                return false;
            }

            if (containsInvalidCharacters())
            {
                IsSupportedLanguage = false;
            }

            return dataStatus;
                          
        }

        private bool containsInvalidCharacters()
        {
             // Ability Descriptions
            foreach (Ability ability in Abilities)
            {
                if (ability.Descriptions.Count == 0)
                {
                    continue;
                }
                foreach (AbilityDescription desc in ability.Descriptions)
                {
                    if (desc.Description.Contains(Convert.ToString((char) 65533)))
                    {
                        Logger.Log(ELogLevel.Info, null, "Invalid characters in update. Server: {0}.", ServerName);
                        return true;
                    }
                }
            }

            return false;
        }

    }
}
