﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Net;
using System.Configuration;

namespace FakePayPalRevoker
{
    public static class VindiciaConfiguration
    {

        public static string Username { get; set; }
        public static string Password { get; set; }
        public static string EndpointUrl { get; set; }

        public static void Initialize()
        {
            //Logger.Log("Vindicia Configuration Initializing...", ELogLevel.Info);

            ServicePointManager.ServerCertificateValidationCallback = delegate { return true; };
            
            Username = ConfigurationManager.AppSettings["VindiciaUsername"];
            Password = ConfigurationManager.AppSettings["VindiciaPassword"];
            EndpointUrl = ConfigurationManager.AppSettings["VindiciaEndpointUrl"];

            Vindicia.Environment.SetEndpoint(EndpointUrl);
            Vindicia.Environment.SetAuth(Username, Password);
                                    
            //Logger.Log("Vindicia Configuration Initialized", ELogLevel.Info);
        }

    }
}
