﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.ServiceModel.Dispatcher;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;

namespace FakePayPalRevoker
{
    public class WebServiceApiKey : IClientMessageInspector
    {
        
        #region IClientMessageInspector Members

        public void AfterReceiveReply(ref System.ServiceModel.Channels.Message reply, object correlationState)
        {

        }

        //All our requests need to have the custom authorization headers
        public object BeforeSendRequest(ref System.ServiceModel.Channels.Message request, System.ServiceModel.IClientChannel channel)
        {
            //Get the HttpRequestMessage property from the message
            HttpRequestMessageProperty httpreq = null;
            try
            {
                httpreq = request.Properties[HttpRequestMessageProperty.Name] as HttpRequestMessageProperty;
            }
            catch
            {

            }

            if (httpreq == null)
            {
                httpreq = new HttpRequestMessageProperty();
                request.Properties.Add(HttpRequestMessageProperty.Name, httpreq);
            }

            httpreq.Headers["apikey"] = "1234567890";

            return null;
        }

        #endregion
    }

    public class WebServiceApiKeyBehavior : IEndpointBehavior
    {
        private WebServiceApiKey _apiKey;

        public WebServiceApiKeyBehavior(WebServiceApiKey apiKey)
        {
            _apiKey = apiKey;
        }

        #region IEndpointBehavior Members

        public void AddBindingParameters(ServiceEndpoint endpoint, BindingParameterCollection bindingParameters)
        {

        }

        public void ApplyClientBehavior(ServiceEndpoint endpoint, ClientRuntime clientRuntime)
        {
            clientRuntime.MessageInspectors.Add(_apiKey);
        }

        public void ApplyDispatchBehavior(ServiceEndpoint endpoint, EndpointDispatcher endpointDispatcher)
        {

        }

        public void Validate(ServiceEndpoint endpoint)
        {

        }

        #endregion
    }

    
}
