﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.Xml;
//using Curse.Cobalt.Extensions;

namespace FakePayPalRevoker
{
    public static class WebServiceHelper
    {
        private static XmlDictionaryReaderQuotas GetDefaultReaderQuotas()
        {
            XmlDictionaryReaderQuotas readerQuotas = new XmlDictionaryReaderQuotas();
            readerQuotas.MaxArrayLength = 16384;
            readerQuotas.MaxBytesPerRead = 4096;
            readerQuotas.MaxNameTableCharCount = 16384;
            readerQuotas.MaxDepth = 64;
            readerQuotas.MaxStringContentLength = 640000;
            return readerQuotas;
        }

        public static WSHttpBinding GetDefaultWSHttpBinding()
        {
            // Reader quotas
            XmlDictionaryReaderQuotas readerQuotas = GetDefaultReaderQuotas();

            WSHttpBinding binding = new WSHttpBinding(SecurityMode.None, false);
            binding.AllowCookies = false;
            binding.CloseTimeout = TimeSpan.FromSeconds(10);
            binding.OpenTimeout = TimeSpan.FromSeconds(10);
            binding.ReceiveTimeout = TimeSpan.FromMinutes(1);
            binding.SendTimeout = TimeSpan.FromMinutes(1);
            binding.UseDefaultWebProxy = true;
            binding.BypassProxyOnLocal = false;
            binding.TransactionFlow = false;
            binding.HostNameComparisonMode = HostNameComparisonMode.StrongWildcard;
            binding.MaxBufferPoolSize = 524288;
            binding.MaxReceivedMessageSize = 2097152;
            binding.MessageEncoding = WSMessageEncoding.Text;
            binding.TextEncoding = Encoding.UTF8;            
            binding.ReaderQuotas = readerQuotas;        
                
            // Disable all builtin security
            binding.Security.Message.EstablishSecurityContext = false;
            binding.Security.Message.ClientCredentialType = MessageCredentialType.None;
            binding.Security.Message.NegotiateServiceCredential = false;
            binding.Security.Transport.ClientCredentialType = HttpClientCredentialType.None;

            return binding;
        }

        //public static ICobaltService GetCobaltServiceClient(string applicationIdentity)
        //{
        //    string enpointUrl = "http://{0}-service.{1}/{2}Service.svc/Soap12/".FormatWith(applicationIdentity.ToLower(), CobaltConfiguration.Global.ApplicationDomain, applicationIdentity);
            
        //    WSHttpBinding binding = WebServiceHelper.GetDefaultWSHttpBinding();
        //    ChannelFactory<ICobaltService> factory = new ChannelFactory<ICobaltService>(binding, new EndpointAddress(enpointUrl));
            
        //    // Initialise the authorization Headers
        //    WebServiceApiKey apiKey = new WebServiceApiKey();

        //    // Create a behaviour
        //    WebServiceApiKeyBehavior behaviour = new WebServiceApiKeyBehavior(apiKey);

        //    //Add the authorization Headers before Sending the Message
        //    factory.Endpoint.Behaviors.Add(behaviour);

        //    return factory.CreateChannel();
        //}

        //public static T GetCobaltServiceClient<T>(string applicationIdentity)
        //{
        //    string enpointUrl = String.Format("http://{0}-service.{1}/{2}Service.svc/Soap12/", "billing.FormatWith(applicationIdentity.ToLower(), "curselive.local", "Radon");

        //    WSHttpBinding binding = WebServiceHelper.GetDefaultWSHttpBinding();
        //    ChannelFactory<T> factory = new ChannelFactory<T>(binding, new EndpointAddress(enpointUrl));

        //    // Initialise the authorization Headers
        //    WebServiceApiKey apiKey = new WebServiceApiKey();

        //    // Create a behaviour
        //    WebServiceApiKeyBehavior behaviour = new WebServiceApiKeyBehavior(apiKey);

        //    //Add the authorization Headers before Sending the Message
        //    factory.Endpoint.Behaviors.Add(behaviour);

        //    return factory.CreateChannel();
        //}

    }
}
