﻿using System;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class AddOnAuthor : INotifyPropertyChanged
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        [DataMember]
        public string Name
        {
            get;
            set;
        }

        [DataMember]
        public string Url
        {
            get;
            set;
        }

        public AddOnAuthor()
        {

        }

        public AddOnAuthor(string name, string url)
        {
            Name = name;
            Url = url;
        }
       
    }
}
