﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class AddOnFile : INotifyPropertyChanged
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        #region Fields
        List<string> _gameVersions = new List<string>();
        private string _fileName;
        #endregion Fields

        private int _id;
        // Serialized Members
        [DataMember]
        public int Id
        {
            get { return _id; }
            set { _id = value; OnPropertyChanged("Id"); }
        }

        [DataMember]
        public string FileName
        {
            get { return _fileName; }
            set { _fileName = value; OnPropertyChanged("FileName"); }
        }

        private string _fileNameOnDisk;
        [DataMember] 
        public string FileNameOnDisk
        {
            get { return _fileNameOnDisk ?? _fileName; }
            set { _fileNameOnDisk = value; OnPropertyChanged("FileNameOnDisk"); }
        }

        [DataMember]
        public DateTime FileDate { get; set; }

        [DataMember]
        public FileType ReleaseType { get; set; }

        [DataMember]
        public FileStatus FileStatus { get; set; }

        [DataMember]
        public string DownloadURL { get; set; }

        [DataMember]
        public bool IsAlternate {get; set; }

        [DataMember]
        public int AlternateFileId { get; set; }        

        private List<AddOnFileDependency> mDependencies;

        [DataMember]
        public List<AddOnFileDependency> Dependencies
        {
            get
            {
                return mDependencies;
            }
            set
            {
                mDependencies = value;
            }
        }
        
        private bool mIsAvailable;

        [DataMember]
        public bool IsAvailable
        {
            get
            {
                return mIsAvailable;
            }
            set
            {
                mIsAvailable = value;
            }
        }
        
        private List<AddOnModule> mModules;

        [DataMember]
        public List<AddOnModule> Modules
        {
            get
            {
                return mModules;
            }
            set
            {
                mModules = value;
            }
        }

        [DataMember]
        public long PackageFingerprint { get; set; }

        [NonSerialized]
        private string mChangeLog;
        public String Changelog
        {
            get
            {
                return mChangeLog;
            }
            set
            {
                mChangeLog = value;
            }
        }

        [NonSerialized]
        private List<long> mFingerprints;        
        
        public List<long> Fingerprints
        {
            get
            {
                return mFingerprints;
            }
            set
            {
                mFingerprints = value;
            }
        }

        [NonSerialized]
        private Dictionary<string, List<long>> mFolderFingerprints;

        public Dictionary<string, List<long>> FolderFingerprints
        {
            get
            {
                return mFolderFingerprints;
            }
            set
            {
                mFolderFingerprints = value;
            }
        }                

        public AddOnFile()
        {
            Modules = new List<AddOnModule>();
            Fingerprints = new List<long>();
            FolderFingerprints = new Dictionary<string, List<long>>();
            Dependencies = new List<AddOnFileDependency>();
            Fingerprints = new List<long>();
        }

        public AddOnFile Clone()
        {
            return (AddOnFile)MemberwiseClone();
        }

        [DataMember]
        public List<string> GameVersion 
        {
            get { return _gameVersions;  }
            set { _gameVersions = value; } 
        }
        
    }
}
