﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class AddOnFileDependency : INotifyPropertyChanged
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        [DataMember]        
        public int AddOnId
        {
            get;
            set;
        }

        [DataMember]
        public DependencyType Type
        {
            get;
            set;
        }
       
        public AddOnFileDependency()
        {
        }

        public AddOnFileDependency(int pProjectId, byte pDependencyType)
        {
            AddOnId = pProjectId;
            Type = (DependencyType)pDependencyType;                        
        }

        public bool IsAcceptable(AddOnFile dependencyParent)
        {
            
            if (dependencyParent.IsAlternate)
            {
                return (Type == DependencyType.Embedded || Type == DependencyType.Required);
            }
            else
            {
                return (Type == DependencyType.Required);
            }
        }

      
    }
}
