﻿using Newtonsoft.Json;

namespace Curse.AddOns
{   
    public class AddonFeed : FeedFile<AddOn>
    {
        private readonly FeedTimespan _timespan;
        private readonly int _gameID;
        
        public AddonFeed() { }

        public AddonFeed(FeedTimespan timespan, int gameID)
        {
            _timespan = timespan;
            _gameID = gameID;
        }

        public override string RelativeFolderPath
        {
            get { return "addons/" + _gameID + "/v" + Version; }
        }

        public override string RelativeUrlPath
        {
            get
            {
                return "feed/" + RelativeFolderPath;                
            }
        }

        public override string FileName
        {
            get
            {
                return _timespan.ToString().ToLower() +".json.bz2";
            }
        }        
        
        
    }
}
