﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Drawing;
using System.IO;

namespace Curse.AddOns
{
    [Serializable]
    public class Avatar : INotifyPropertyChanged
    {
        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        public int Id { get; set; }

        public string FileName { get; set; }

        public string FilePath { get; set; }

        public AvatarStatus Status { get; set; }

        public int Width { get; set; }

        public int Height { get; set; }

        public long FileLength { get; set; }

        public string Url { get; set; }

        public Avatar() { }

        public Avatar(int id, string fileName, AvatarStatus status, int width, int height, long fileLength, string url)
        {
            Id = id;
            FileName = fileName;
            Status = status;
            Width = width;
            Height = height;
            FileLength = fileLength;
            Url = url;
        }
    }
}
