﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class CAddOnAuthor : INotifyPropertyChanged
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        [DataMember]
        public string Name
        {
            get;
            set;
        }

        [DataMember]
        public string Url
        {
            get;
            set;
        }

        public CAddOnAuthor()
        {

        }

        public CAddOnAuthor(string pName, string pURL)
        {
            Name = pName;
            Url = pURL;
        }
       
    }
}
