﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class CAddOnCategory : INotifyPropertyChanged
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        [DataMember]
        public int Id {get;set;}

        [DataMember]
        public string Name {get;set;}

        [DataMember]
        public string URL {get;set;}

        public CAddOnCategory()
        {
        }

        public CAddOnCategory(int pId, string pName, string pURL)
        {
            Id = pId;
            Name = pName;
            URL = pURL;
        }
       
    }
}
