﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class CAddOnFile : INotifyPropertyChanged
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        // Serialized Members
        [DataMember]
        public int Id { get; set; }
       
        [DataMember]
        public string FileName {get; set;}

        [DataMember]
        public DateTime FileDate { get; set; }

        [DataMember]
        public EFileType ReleaseType { get; set; }

        [DataMember]
        public EFileStatus FileStatus { get; set; }

        [DataMember]
        public string DownloadURL { get; set; }

        [DataMember]
        public bool IsAlternate {get; set; }

        [DataMember]
        public int AlternateFileId { get; set; }        

        private List<CAddOnFileDependency> mDependencies;

        [DataMember]
        public List<CAddOnFileDependency> Dependencies
        {
            get
            {
                return mDependencies;
            }
            set
            {
                mDependencies = value;
            }
        }
        
        private bool mIsAvailable;

        [DataMember]
        public bool IsAvailable
        {
            get
            {
                return mIsAvailable;
            }
            set
            {
                mIsAvailable = value;
            }
        }
        
        private List<CAddOnModule> mModules;

        [DataMember]
        public List<CAddOnModule> Modules
        {
            get
            {
                return mModules;
            }
            set
            {
                mModules = value;
            }
        }

        [DataMember]
        public long PackageFingerprint { get; set; }

        [NonSerialized]
        private string mChangeLog;
        public String Changelog
        {
            get
            {
                return mChangeLog;
            }
            set
            {
                mChangeLog = value;
            }
        }

        [NonSerialized]
        private List<long> mFingerprints;        
        
        public List<long> Fingerprints
        {
            get
            {
                return mFingerprints;
            }
            set
            {
                mFingerprints = value;
            }
        }

        [NonSerialized]
        private Dictionary<string, List<long>> mFolderFingerprints;
        public Dictionary<string, List<long>> FolderFingerprints
        {
            get
            {
                return mFolderFingerprints;
            }
            set
            {
                mFolderFingerprints = value;
            }
        }                

        public CAddOnFile()
        {
            Modules = new List<CAddOnModule>();
            Fingerprints = new List<long>();
            FolderFingerprints = new Dictionary<string, List<long>>();
            Dependencies = new List<CAddOnFileDependency>();
            Fingerprints = new List<long>();
        }

        public CAddOnFile Clone()
        {
            return (CAddOnFile)MemberwiseClone();
        }

        [DataMember]
        public List<string> GameVersion 
        {
            get { return _gameVersions;  }
            set { _gameVersions = value; } 
        }
        List<string> _gameVersions = new List<string>();
    }
}
