﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Drawing;
using System.Net;
using Curse.Extensions;
using System.IO;

namespace Curse.AddOns
{
    [Serializable]
    public class CAvatar : INotifyPropertyChanged
    {
        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        public int Id { get; set; }

        public string FileName { get; set; }

        public string FilePath { get; set; }

        public EAvatarStatus Status { get; set; }

        public int Width { get; set; }

        public int Height { get; set; }

        public long FileLength { get; set; }

        private Bitmap _icon;
        public Bitmap Icon
        {
            get
            {
                if (_icon == null)
                {
                    try
                    {
                        //Return null if we have no fileUrl to check
                        if (FilePath == null) return null;

                        if (File.Exists(FilePath))
                        {
                            _icon = ResampleImage(new Bitmap(FilePath));
                        }
                    }
                    catch (Exception ex)
                    {
                        Logger.Log("Unable to locate avatar at '{0}'. Details: {1}", ELogLevel.Error, FilePath, ex.GetExceptionDetails());
                    }
                }
                return _icon;
            }
            set
            {
                _icon = ResampleImage(value);
            }
        }

        public CAvatar() { }

        public CAvatar(int id, string fileName, EAvatarStatus status, int width, int height, long fileLength, Bitmap icon)
        {
            Id = id;
            FileName = fileName;
            Status = status;
            Width = width;
            Height = height;
            FileLength = fileLength;
            Icon = icon;
        }//construct

        private static Bitmap ResampleImage(Bitmap img)
        {
            Bitmap newImage = new Bitmap(32, 32);
            using (Graphics gfx = Graphics.FromImage(newImage))
            {
                gfx.CompositingMode = System.Drawing.Drawing2D.CompositingMode.SourceCopy;

                gfx.Clear(Color.White);
                gfx.DrawImage(img, new Rectangle(0, 0, 32, 32), 0, 0, img.Width, img.Height, GraphicsUnit.Pixel);
            }//using gfx
            return newImage;
        }//resample the image
    }//class
}//namespace
