﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.ComponentModel;

namespace Curse.AddOns
{
    [Serializable]
    public class CCategory : INotifyPropertyChanged
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        public int Id { get; set; }

        public int? ParentId { get; set; }

        public string Name { get; set; }

        public string Slug { get; set; }

        public Bitmap Icon { get; set; }

        public List<int> GameIDs { get; set; }

        public CCategory()
        {
            GameIDs = new List<int>();
        }

        public CCategory(int id, int? parentId, string name, string slug, Bitmap icon, List<int> gameIDs)
        {
            Id = id;
            ParentId = parentId;
            Name = name;
            Slug = slug;
            Icon = icon;
            GameIDs = gameIDs;
        }

    }
}
