﻿using System;
using System.Text.RegularExpressions;
using System.Runtime.Serialization;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class CFileParsingRule
    {
        [DataMember]
        public string CommentStripPattern
        {
            get;
            set;
        }

        private Regex mCommentStripRegex = null;
        public Regex CommentStripRegex
        {
            get
            {
                if (CommentStripPattern != null && mCommentStripRegex == null)
                {
                    mCommentStripRegex = new Regex(CommentStripPattern);
                }
                return mCommentStripRegex;
            }
        }

        [DataMember]
        public string FileExtension
        {
            get;
            set;
        }

        [DataMember]
        public string InclusionPattern
        {
            get;
            set;
        }

        private Regex mInclusionRegex = null;
        public Regex InclusionRegex
        {
            get
            {
                if (mInclusionRegex == null)
                {
                    mInclusionRegex = new Regex(InclusionPattern);
                }
                return mInclusionRegex;
            }
        }

        public CFileParsingRule()
        {
        }

        public CFileParsingRule(string fileExtension, string inclusionPattern, string commentStripPattern)
        {
            if (commentStripPattern != null)
            {
                CommentStripPattern = commentStripPattern;
            }
            FileExtension = fileExtension;
            InclusionPattern = inclusionPattern;
        }

    }
}
