﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace Curse.AddOns
{
    [DataContract(Namespace = "Curse.AddOns")]
    public class CFingerprintMatch
    {

        [DataMember]
        public int Id
        {
            get;set;
        }
        
        [DataMember]
        public CAddOnFile File
        {
            get;
            set;
        }       

        [DataMember]
        public List<CAddOnFile> LatestFiles
        {
            get;
            set;
        }

        public CFingerprintMatch()
        {

        }

        public CFingerprintMatch(CAddOn pAddOn, CAddOnFile pFile)         
        {
            Id = pAddOn.Id;
            File = pFile;
            LatestFiles = pAddOn.LatestFiles;            
        }

        public bool IsExactMatch(List<long> pFingerprints)
        {                        
            foreach (long fingerprint in File.Fingerprints)
            {
                if (!pFingerprints.Contains(fingerprint))
                {
                    return false;
                }
            }
            return true;
        }

        public List<long> GetPartialMatchFingerprints(List<long> pFingerprints)
        {
            List<long> partialMatches = new List<long>();
            foreach (long fingerprint in File.Fingerprints)
            {
                if (pFingerprints.Contains(fingerprint))
                {
                    partialMatches.Add(fingerprint);
                }
            }
            return partialMatches;
        }              
    }
}
