﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace Curse.AddOns
{
    [DataContract(Namespace = "Curse.AddOns")]
    public class CFuzzyMatch
    {                        

        [DataMember]
        public int Id
        {
            get;
            set;
        }

        [DataMember]
        public CAddOnFile File
        {
            get;
            set;
        }

        [DataMember]
        public List<CAddOnFile> LatestFiles
        {
            get;
            set;
        }

        private List<long> mFingerprints;

        public List<long> Fingerprints
        {
            get
            {
                return mFingerprints;
            }
        }        

        private bool IsFuzzyMatch(long s)
        {
            return mFingerprints.BinarySearch(s) >= 0;
        }

        public int FuzzyMatchCount(List<long> pFingerprints)
        {
            return pFingerprints.FindAll(IsFuzzyMatch).Count;
        }        

        public CFuzzyMatch(string pFolderName, CAddOn pAddOn, CAddOnFile pAddOnFile)
        {            
            LatestFiles = pAddOn.LatestFiles;
            Id = pAddOn.Id;
            File = pAddOnFile;
            mFingerprints = pAddOnFile.FolderFingerprints[pFolderName];            
        }
    }
}
