﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Runtime.Serialization;
using System.ComponentModel;
using System.Drawing;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class CGame : INotifyPropertyChanged
    {
        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        private int mId;
        private string mName;
        private string mExecutableFilename;
        private string mLauncherFilename;
        private string mAddOnPath;
        private Regex mInitialInclusionRegex = null;
        private Regex mExtraIncludeRegex = null;
        private List<CCategorySection> _categorySections = new List<CCategorySection>();
        private ESavedGameScanType _scanType = ESavedGameScanType.Event;

        private string mStageName;

        [DataMember]
        public int ID
        {
            get
            {
                return mId;
            }
            set
            {
                mId = value;
            }
        }

        [DataMember]
        public DateTime DateModified
        {
            get;
            set;
            
        }

        [DataMember]
        public string Name
        {
            get
            {
                return mName;
            }
            set
            {
                mName = value;
            }
        }

        [DataMember]
        public string AddOnPath
        {
            get
            {
                return mAddOnPath;
            }
            set
            {
                mAddOnPath = value;
            }
        }

        [DataMember]
        public string ExecutableFilename
        {
            get
            {
                return mExecutableFilename;
            }
            set
            {
                mExecutableFilename = value;
            }
        }

        [DataMember]
        public string LauncherFilename
        {
            get
            {
                return mLauncherFilename;
            }
            set
            {
                mLauncherFilename = value;
            }
        }

        [DataMember]
        public int ProfilerAddOnId
        {
            get;
            set;            
        }

        [DataMember]
        public List<string> ExcludedPaths
        {
            get;
            set;
        }
        
        [DataMember]
        public List<CFileParsingRule> FileParsingRules
        {
            get;
            set;
        }

        [DataMember]
        public List<CGameDetectionHint> GameDetectionHints
        {
            get;
            set;
        }

        [DataMember]
        [Obsolete("Moved to the CCategorySection")]
        public string InitialInclusionPattern
        {
            get;
            set;
        }

        [DataMember]
        public string AddOnSettingsStartingFolder
        {
            get;
            set;
        }

        [DataMember]
        public string AddOnSettingsFolderFilter
        {
            get;
            set;
        }

        [DataMember]
        public string AddOnSettingsFileFilter
        {
            get;
            set;
        }
       
        [DataMember]
        public string AddOnSettingsFileRemovalFilter
        {
            get;
            set;
        }

        [DataMember]
        [Obsolete("Moved to the CCategorySection")]
        public string ExtraIncludePattern
        {
            get;
            set;
        }

        [DataMember]
        public List<CCategorySection> CategorySections
        {
            get { return _categorySections; }
            set { _categorySections = value; }
        }

        [Obsolete("Moved to the CCategorySection")]
        public Regex InitialInclusionRegex
        {
            get
            {
                if (mInitialInclusionRegex == null)
                {
                    mInitialInclusionRegex = new Regex(InitialInclusionPattern);
                }
                return mInitialInclusionRegex;
            }
        }

        [Obsolete("Moved to the CCategorySection")]
        public Regex ExtraIncludeRegex
        {
            get
            {
                if (ExtraIncludePattern != null && mExtraIncludeRegex == null)
                {
                    mExtraIncludeRegex = new Regex(ExtraIncludePattern);
                }
                return mExtraIncludeRegex;
            }
        }

        public bool SupportsAddonSettings
        {
            get
            {
                return AddOnSettingsStartingFolder != null;
            }
        }
        
        [DataMember]
        public string StageName
        {
            get
            {
                return mStageName;
            }
            set
            {
                mStageName = value;
            }
        }

        [DataMember]
        public bool SyncSavedGames { get; set; }

        [DataMember]
        public string SavedGameFolder { get; set; }

        [DataMember]
        public ESavedGameScanType SavedGameScanType { get { return _scanType; } set { _scanType = value; } }

        [DataMember]
        public long SavedGameScanInterval { get; set; }

        [DataMember]
        public string SavedGameFilter { get; set; }

        [DataMember]
        public long MaxFileSize { get; set; }

        [DataMember]
        public Bitmap Icon { get; set; }

        [DataMember]
        public List<CGameResource> Resources { get; set; }

        [DataMember]
        public CGameUiOptions GameUiOptions { get; set; }

        [DataMember]
        public CGameFeatures GameFeatures { get; set; }

        [DataMember]
        public long MaxFreeStorage { get; set; }

        [DataMember]
        public long MaxPremiumStorage { get; set; }

        public CGame()
        {
            ExcludedPaths = new List<string>();
            FileParsingRules = new List<CFileParsingRule>();
            GameDetectionHints = new List<CGameDetectionHint>();
        }       
    }
}
