﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.ComponentModel;

namespace Curse.AddOns
{
    [Serializable]
    public class Category : INotifyPropertyChanged
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        public int Id { get; set; }

        public int? ParentId { get; set; }

        public string Name { get; set; }

        public string Slug { get; set; }

        public string AvatarUrl { get; set; }

        public List<int> GameIDs { get; set; }

        public Category()
        {
            GameIDs = new List<int>();
        }

        public Category(int id, int? parentId, string name, string slug, string avatarUrl, List<int> gameIDs)
        {
            Id = id;
            ParentId = parentId;
            Name = name;
            Slug = slug;
            AvatarUrl = avatarUrl;
            GameIDs = gameIDs;
        }

    }
}
