﻿using System;
using System.Runtime.Serialization;
using System.Text.RegularExpressions;
using System.IO;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class CategorySection
    {
        private Regex mInitialInclusionRegex = null;
        private Regex mExtraIncludeRegex = null;

        [DataMember]
        public int ID { get; set; }

        [DataMember]
        public int GameID { get; set; }

        [DataMember]
        public string Name { get; set; }

        [DataMember]
        public PackageTypes PackageType
        {
            get { return _packageType; }
            set { _packageType = value; }
        }

        PackageTypes _packageType = PackageTypes.Folder;

        [DataMember]
        public string Path { get; set; }

        [DataMember]
        public string InitialInclusionPattern { get; set; }

        [DataMember]
        public string ExtraIncludePattern { get; set; }

        public Regex InitialInclusionRegex
        {
            get
            {
                if (mInitialInclusionRegex == null)
                {
                    mInitialInclusionRegex = new Regex(InitialInclusionPattern);
                }
                return mInitialInclusionRegex;
            }
        }

        public Regex ExtraIncludeRegex
        {
            get
            {
                if (ExtraIncludePattern != null && mExtraIncludeRegex == null)
                {
                    mExtraIncludeRegex = new Regex(ExtraIncludePattern);
                }
                return mExtraIncludeRegex;
            }
        }

        [NonSerialized]
        private DirectoryInfo directory = null;
        public DirectoryInfo Directory
        {
            get
            {
                return directory;
            }
            set
            {
                directory = value;
            }
        }
    }
}
