﻿using System;
using System.IO;
using Newtonsoft.Json;

namespace Curse.AddOns
{
    [JsonObject(MemberSerialization.OptIn)]
    public class FeedFile<TItem>
    {
        [JsonProperty("timestamp")]
        public long Timestamp { get; set; }

        [JsonProperty("data")]
        public TItem[] Data { get; set; }

        public virtual int Version
        {
            get { return 10; }
        }

        public virtual string RelativeFolderPath 
        {
            get
            {
                throw new NotImplementedException();        
            }
        }

        public virtual string RelativeUrlPath
        {
            get
            {
                throw new NotImplementedException();
            }
        }

        public virtual string FileName
        {
            get
            {
                throw new NotImplementedException();
            }
        }

        public string FullRelativeFilePath
        {
            get { return Path.Combine(RelativeUrlPath, FileName); }
        }

        public string FullRelativeUrlPath
        {
            get { return Path.Combine(RelativeUrlPath, FileName); }
        }

        public Uri GetUri(Uri baseUri)
        {
            return new Uri(baseUri, FullRelativeUrlPath);
        }
       
    }
}
