﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace Curse.AddOns
{
    [DataContract(Namespace = "Curse.AddOns")]
    public class FingerprintMatchResult
    {
        [DataMember]
        public bool IsCacheBuilt
        {
            get;
            set;
        }

        // Properties
        [DataMember]
        public List<FingerprintMatch> ExactMatches
        {
            get;
            set;
        }

        public List<long> ExactFingerprints
        {
            get;
            set;
        }

        [DataMember]
        public List<FingerprintMatch> PartialMatches
        {
            get;
            set;
        }
        
        public Dictionary<int, List<long>> PartialMatchFingerprints
        {
            get;
            set;
        }
        
        public List<long> InstalledFingerprints
        {
            get;set;
        }

        private bool IsUnmatched(long s)
        {
            return !ExactFingerprints.Contains(s);
        }        

        public List<long> UnmatchedFingerprints
        {
            get
            {                
                return InstalledFingerprints.FindAll(IsUnmatched);             
            }
        }
        
        // Constructor
        public FingerprintMatchResult()
        {
            InstalledFingerprints = new List<long>();
            ExactMatches = new List<FingerprintMatch>();
            PartialMatches = new List<FingerprintMatch>();
            ExactFingerprints = new List<long>();
            PartialMatchFingerprints = new Dictionary<int, List<long>>();
        }
    }
}
