﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace Curse.AddOns
{
    [DataContract(Namespace = "Curse.AddOns")]
    public class FuzzyMatch
    {                        

        [DataMember]
        public int Id
        {
            get;
            set;
        }

        [DataMember]
        public AddOnFile File
        {
            get;
            set;
        }

        [DataMember]
        public List<AddOnFile> LatestFiles
        {
            get;
            set;
        }

        private List<long> mFingerprints;

        public List<long> Fingerprints
        {
            get
            {
                return mFingerprints;
            }
        }        

        private bool IsFuzzyMatch(long s)
        {
            return mFingerprints.BinarySearch(s) >= 0;
        }

        public int FuzzyMatchCount(List<long> pFingerprints)
        {
            return pFingerprints.FindAll(IsFuzzyMatch).Count;
        }        

        public FuzzyMatch(string pFolderName, AddOn pAddOn, AddOnFile pAddOnFile)
        {            
            LatestFiles = pAddOn.LatestFiles;
            Id = pAddOn.Id;
            File = pAddOnFile;
            mFingerprints = pAddOnFile.FolderFingerprints[pFolderName];            
        }
    }
}
